//Source file: H:\src\Alkindi\Services\Client\BeanUtil.java

/* Copyright (C) 2000-2001 Alkindi, Inc. */

package Alkindi.Services.Client;

import java.rmi.*;
import javax.naming.*;
import javax.ejb.*;
import Alkindi.Services.BeanIface.*;
import javax.rmi.PortableRemoteObject;
import java.util.Properties;
import Alkindi.Services.AlkExcept;

/* 
$Header: BeanUtil.java, 3, 4/27/01 4:59:51 PM, Schwartz, Joe$
$Log: 
 3    Alkindi Development1.2         4/27/01 4:59:51 PM   Schwartz, Joe  
      Changed bean accessor methods to throw only AlkExcept.
 2    Alkindi Development1.1         4/23/01 10:21:43 AM  Schwartz, Joe   Fixed
      up package reference.
 1    Alkindi Development1.0         4/23/01 9:43:35 AM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 */
public class BeanUtil 
{
	
	/**
	 * Gets a reference to an AccountManager EJB.
	 * @roseuid 3AE43262012D
	 */
	public static IAccountManagerBean getAcctMgr() throws AlkExcept 
	{
		try {
			Object obj = getHomeIface("ejb/AcctMgrBean");
			IAccountManagerHome home =  (IAccountManagerHome)PortableRemoteObject.narrow(obj, IAccountManagerHome.class);
			return home.create();
		}
		catch (Exception e) {
			throw new AlkExcept("Error getting AccountManager bean: " + e.getMessage(), 8001, e);
		}
	}
	
	/**
	 * Gets a reference to a ClusterManager EJB.
	 * @roseuid 3AE43262012F
	 */
	public static IClusterManagerBean getClusterMgr() throws AlkExcept 
	{
		try {
			Object obj = getHomeIface("ejb/ClusterMgrBean");
			IClusterManagerHome home = (IClusterManagerHome)PortableRemoteObject.narrow(obj, IClusterManagerHome.class);
			return home.create();
		}
		catch(Exception e) {
			throw new AlkExcept("Error getting ClusterManager bean: " + e.getMessage(), 8002, e);
		}
	}
	
	/**
	 * Retrieves a Home Interface for the named EJB.
	 * @roseuid 3AE43262012B
	 */
	public static Object getHomeIface(String IfaceName) throws NamingException 
	{
		Context initCtx = getInitCtx();
		Object obj = initCtx.lookup(IfaceName);
		initCtx.close();
		return obj;
	}
	
	/**
	 * Retrieves the InitialContext for the current JVM.
	 * @roseuid 3AE43262012A
	 */
	static Context getInitCtx() 
	{
		Context initCtx = null;
		System.setSecurityManager(new RMISecurityManager());
		System.out.println("Starting BeanUtil");
		try {
			initCtx = new InitialContext();
			System.out.println("BeanUtil got new init ctx.");
			printCtxEnv(initCtx);
		}
		catch(Exception e) {
			System.out.println("Exception in BeanUtil constructor:\n" + e.toString());
			System.exit(1);
		}
		return initCtx;
	}
	
	/**
	 * Gets a reference to a RatingManager EJB.
	 * @roseuid 3AE43262012E
	 */
	public static IRatingManagerBean getRatMgr() throws AlkExcept 
	{
		try {
			Object obj = getHomeIface("ejb/RatingMgrBean");
			IRatingManagerHome home = (IRatingManagerHome)PortableRemoteObject.narrow(obj, IRatingManagerHome.class);
			return home.create();
		}
		catch(Exception e) {
			throw new AlkExcept("Error getting RatingManager bean: " + e.getMessage(), 8003, e);
		}
	}
	
	/**
	 * Gets a reference to a RecommendationManager EJB.
	 * @roseuid 3AE432620138
	 */
	public static IRecommendationManagerBean getRecMgr() throws AlkExcept 
	{
		try {
			Object obj = getHomeIface("ejb/RecMgrBean");
			IRecommendationManagerHome home = (IRecommendationManagerHome)PortableRemoteObject.narrow(obj, IRecommendationManagerHome.class);
			return home.create();
		}
		catch(Exception e) {
			throw new AlkExcept("Error getting RecManager bean: " + e.getMessage(), 8004, e);
		}
	}
	
	/**
	 * Gets a reference to a Search Manager EJB.
	 * @roseuid 3AE432620139
	 */
	public static ISearchManagerBean getSearchMgr() throws AlkExcept 
	{
		try {
			Object obj = getHomeIface("ejb/SearchMgrBean");
			ISearchManagerHome home = (ISearchManagerHome)PortableRemoteObject.narrow(obj, ISearchManagerHome.class);
			return home.create();
		}
		catch(Exception e) {
			throw new AlkExcept("Error getting SearchManager bean: " + e.getMessage(), 8005, e);
		}
	}
	
	/**
	 * Utility to print the InitialContext environment. Useful for debugging.
	 * @roseuid 3AE432620128
	 */
	static void printCtxEnv(final Context ctx) throws NamingException 
	{
		System.out.println("Context environment:");
		final java.util.Hashtable env = ctx.getEnvironment();
		java.util.Enumeration kenum = env.keys();
		while (kenum.hasMoreElements()) {
			Object key = kenum.nextElement();
			System.out.println(key.toString() + ": " + env.get(key));
		}
	}
}
